# Generated Python Strategy for: PlayerA (meta)
# Run Index: 5
# Primary LLM: DeepSeek-V3 (deepseek-ai/DeepSeek-V3-0324) Provider: novita
def PlayerA_DeepSeek_V3_MetaAgent_Run5_Iter0(my_history: list, opp_history: list, opponent_program_code: str) -> str:
    # Initial move: Cooperate
    if not my_history:
        return "C"
    
    # Heuristic analysis of opponent's code
    opponent_code = opponent_program_code.lower()
    
    # Check for simple strategies
    is_always_cooperate = "always_cooperate" in opponent_code or "return 'c'" in opponent_code
    is_always_defect = "always_defect" in opponent_code or "return 'd'" in opponent_code
    is_tit_for_tat = "tit_for_tat" in opponent_code or ("opp_history[-1]" in opponent_code and "return opp_history[-1]" in opponent_code)
    
    # Check for suspicious patterns (e.g., frequent defection)
    defect_keywords = ["defect", "return d", "return 'd'", "betray"]
    cooperate_keywords = ["cooperate", "return c", "return 'c'", "trust"]
    defect_count = sum(opponent_code.count(kw) for kw in defect_keywords)
    cooperate_count = sum(opponent_code.count(kw) for kw in cooperate_keywords)
    
    # Check for self-similarity (if opponent's code resembles our own)
    our_keywords = ["deepseek", "v3", "metaagent", "run5", "iter0"]
    is_similar = any(kw in opponent_code for kw in our_keywords)
    
    # Check for complexity (short code might be simple, long code might be complex)
    code_lines = opponent_program_code.splitlines()
    is_simple = len(code_lines) < 5
    
    # Decision logic
    if is_always_cooperate:
        return "C"
    elif is_always_defect:
        return "D"
    elif is_tit_for_tat:
        return opp_history[-1]
    elif is_similar:
        return "C"
    elif defect_count > cooperate_count + 2:
        return "D"
    elif cooperate_count > defect_count + 2:
        return "C"
    elif is_simple:
        return "C"
    else:
        # Default to Tit-for-Tat if unsure
        return opp_history[-1] if opp_history else "C"